;;; FUSION -Gilles Chanteau- 01/01/06

;;; Cre une polyligne sur le contour de chaque gorupe de polylignes fermes et contigus slectionnes.


(defun c:fusion (/ gile_vl_err       join-pline        arcbulge

                   AcDoc    Space    ss       lst      reg

                   Norm     expl     objs     regs     olst

                   blst     plst     dlst     tlst     blg

                   pline

                  )

  (vl-load-com)


;;;***************************************************************;;;


  (defun gile_vl_err (msg)

    (if (or

          (= msg "Fonction annule")

          (= msg "quitter / sortir abandon")

        )

      (princ)

      (princ (strcat "\nErreur: " msg))

    )

    (vla-endundomark

      (vla-get-activedocument (vlax-get-acad-object))

    )

    (setq *error* m:err

          m:err nil

    )

    (princ)

  )


;;;***************************************************************;;;


  (defun arcbulge (arc)

    (/ (sin (/ (vla-get-TotalAngle arc) 4))

       (cos (/ (vla-get-TotalAngle arc) 4))

    )

  )


;;;***************************************************************;;;


  (setq AcDoc   (vla-get-activeDocument (vlax-get-acad-object))

        Space   (if (= 1 (getvar "CVPORT"))

                  (vla-get-PaperSpace AcDoc)

                  (vla-get-Modelspace AcDoc)

                )

        m:err   *error*

        *error* gile_vl_err

  )

  (prompt "\nSlectionnez les polylignes  fusionner: ")

  (if (setq ss (ssget '((0 . "LWPOLYLINE"))))

    (progn

      (vla-StartUndoMark AcDoc)

      (if (setq reg

                 (vlax-invoke

                   Space

                   'addRegion

                   (mapcar 'vlax-ename->vla-object

                           (vl-remove-if 'listp (mapcar 'cadr (ssnamex ss)))

                   )

                 )

          )

        (progn

          (while (cadr reg)

            (vla-boolean

              (car reg)

              acUnion

              (cadr reg)

            )

            (setq reg (cons (car reg) (cddr reg)))

          )

          (setq reg  (car reg)

                Norm (vlax-get reg 'Normal)

                expl (vlax-invoke reg 'Explode)

          )

          (vla-delete reg)

          (while expl

          (setq objs (vl-remove-if-not

                       '(lambda (x)

                          (or

                            (= (vla-get-ObjectName x) "AcDbLine")

                            (= (vla-get-ObjectName x) "AcDbArc")

                          )

                        )

                       expl

                     )

                regs (vl-remove-if-not

                       '(lambda (x) (= (vla-get-ObjectName x) "AcDbRegion"))

                       expl

                     )

          )

          (if objs

            (progn

              (setq olst (mapcar '(lambda (x)

                                    (list x

                                          (vlax-get x 'StartPoint)

                                          (vlax-get x 'EndPoint)

                                    )

                                  )

                                 objs

                         )

              )

              (while olst

                (setq blst nil)

                (if (= (vla-get-ObjectName (caar olst)) "AcDbArc")

                  (setq blst (list (cons 0 (arcbulge (caar olst)))))

                )

                (setq plst (cdar olst)

                      dlst (list (caar olst))

                      olst (cdr olst)

                )

                (while

                  (setq

                    tlst (vl-member-if

                           '(lambda (x)

                              (or (equal (last plst) (cadr x) 1e-9)

                                  (equal (last plst) (caddr x) 1e-9)

                              )

                            )

                           olst

                         )

                  )

                   (if (equal (last plst) (caddar tlst) 1e-9)

                     (setq blg -1)

                     (setq blg 1)

                   )

                   (if (= (vla-get-ObjectName (caar tlst)) "AcDbArc")

                     (setq

                       blst (cons (cons (1- (length plst))

                                        (* blg (arcbulge (caar tlst)))

                                  )

                                  blst

                            )

                     )

                   )

                   (setq plst (append plst

                                      (if (minusp blg)

                                        (list (cadar tlst))

                                        (list (caddar tlst))

                                      )

                              )

                         dlst (cons (caar tlst) dlst)

                         olst (vl-remove (car tlst) olst)

                   )

                )

                (setq pline

                       (vlax-invoke

                         Space

                         'addLightWeightPolyline

                         (apply 'append

                                (mapcar '(lambda (x)

                                           (setq x (trans x 0 Norm))

                                           (list (car x) (cadr x))

                                         )

                                        (reverse (cdr (reverse plst)))

                                )

                         )

                       )

                )

                (vla-put-Closed pline :vlax-true)

                (mapcar

                  '(lambda (x) (vla-setBulge pline (car x) (cdr x)))

                  blst

                )

                (vla-put-Elevation

                  pline

                  (caddr (trans (car plst) 0 Norm))

                )

                (vla-put-Normal pline (vlax-3d-point Norm))

                (vla-Highlight pline :vlax-true)

                (mapcar 'vla-delete dlst)

              )

            )

          )

          (if regs

            (progn

              (setq

                expl (append (vlax-invoke (car regs) 'Explode)

                             (cdr regs)

                     )

              )

              (vla-delete (car regs))

            )

            (setq expl nil)

          )

        )

        )

      )

      (vla-EndUndoMark AcDoc)

    )

  )

  (setq *error* m:err

        m:err nil

  )

  (princ)

)