;; Apply a transformation matrix to a vector by Vladimir Nesterovsky
(defun mxv (m v)
  (mapcar '(lambda (r) (apply '+ (mapcar '* r v))) m)
)

;;;**************************************************************************;;;
;; D'aprs Bonuscad
;; Retourne dans la fentre de texte la dfinition d'un motif de hachure.
;; Propose l'enregistrement dans un fichier.

(defun c:model_hatch
       (/ err zindim ent elst vec rot scale nb ang n first)

  (defun err (msg)
    (if	(= msg "Fonction annule")
      (princ)
      (princ (strcat "\nErreur: " msg))
    )
    (setvar "dimzin" zindim)
    (setq *error* m:err
	  m:err	nil
    )
    (princ)
  )

  (setq	m:err *error*
	*error*	err
  )
  (while (not (setq ent (entsel "\nChoix de la Hachure modle: ")))
  )
  (setq	elst   (entget (car ent))
	zindim (getvar "dimzin")
  )
  (if (= (getvar "measurement") 1)
    (setvar "dimzin" 8)
    (setvar "dimzin" 12)
  )
  (if (= (cdr (assoc 0 elst)) "HATCH")
    (progn
      (setq
	descr (strcat "\n*" (cdr (assoc 2 elst)))
	rot   (cdr (assoc 52 elst))
	scale (/ 1.0 (cdr (assoc 41 elst)))
	nb    (cdr (assoc 78 elst))
	first T
      )
      (repeat nb
	(setq elst  (member (assoc 53 elst) elst)
	      ang   (cdar elst)
	      descr
		    (strcat descr
			    "\n"
			    (angtos (- ang rot) 0 14)
		    )
	      elst  (cdr elst)
	)
	(repeat	2
	  (setq	vec
		 ((lambda (a)
		    (mxv (list
			   (list (cos a) (- (sin a)) 0.0)
			   (list (sin a) (cos a) 0.0)
			   '(0.0 0.0 1.0)
			 )
			 (list (* scale (cdar elst))
			       (* scale (cdadr elst))
			       0.0
			 )
		    )
		  )
		   (if first
		     (- rot)
		     (- ang)
		   )
		 )
	  )
	  (setq first nil)
	  (setq	descr (strcat descr
			      ","
			      (rtos (car vec) 2 14)
			      ","
			      (rtos (cadr vec) 2 14)
		      )
		elst  (cddr elst)
	  )
	)
	(repeat	(cdr (assoc 79 elst))
	  (setq elst (cdr elst))
	  (setq	descr (strcat descr
			      ","
			      (rtos (* scale (cdar elst)) 2 14)
		      )
	  )
	)
	(setq first T)
      )
      (textscr)
      (princ descr)
      (initget "Oui Non")
      (if (and
	    (= (getkword
		 "\nEnregistrer dans un fichier ? [Oui/Non] <Non>: "
	       )
	       "Oui"
	    )
	    (setq file (getfiled "Slectionnez un fichier"
				 (if (= (getvar "measurement") 1)
				   (findfile "acadiso.pat")
				   (findfile "acad.pat")
				 )
				 "pat"
				 33
		       )
	    )
	  )
	(progn
	  (setq file (open file "a"))
	  (princ (strcat (substr descr 2) "\n") file)
	  (close file)
	)
      )
      (graphscr)
    )
    (T (prompt "\nEntit n'est pas une hachure."))
  )
  (setvar "dimzin" zindim)
  (setq	*error*	m:err
	m:err nil
  )
  (princ)
)